/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.network;

import com.ibm.hsc.auiml.databeans.network.IPBeans;
import com.ibm.ui.framework.swing.ChoiceDescriptor;
import com.ibm.ui.framework.swing.DataBean;
import com.ibm.ui.framework.swing.EventHandler;
import com.ibm.ui.framework.swing.IllegalUserDataException;
import com.ibm.ui.framework.swing.ItemDescriptor;
import com.ibm.ui.framework.swing.PanelManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SaveEntryInput
extends EventHandler
implements ActionListener {
    private PanelManager myPm = null;
    private DataBean[] db;
    private ItemDescriptor[] m_idTType;
    String buttonType = "";
    String[] buttonTypes = new String[]{"net", "host", "default"};
    String[] routeTypes = new String[]{"NETBUTTON", "HOSTBUTTON", "DEFAULTBUTTON"};
    String before = "BEFOREBUTTON";
    String after = "AFTERBUTTON";
    int index;
    int rowSelected;

    public SaveEntryInput(PanelManager panelManager) {
        super(panelManager);
        this.myPm = panelManager;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (!string.equals("ROUTEOK_BUTTON")) {
            this.handleTypeSelection(string);
            return;
        }
        try {
            ItemDescriptor[] itemDescriptorArray;
            this.myPm.applyChanges();
            this.db = this.myPm.getDataBeans();
            IPBeans iPBeans = (IPBeans)this.db[0];
            String string2 = iPBeans.getEntryPosition();
            String string3 = iPBeans.getRouteType();
            String string4 = iPBeans.getDestination();
            String string5 = iPBeans.getGateway();
            String string6 = iPBeans.getSubnetMask();
            String string7 = ((ChoiceDescriptor)iPBeans.getDevice()).getTitle();
            this.rowSelected = iPBeans.getTGatewaySelectionIndex();
            this.buttonType = this.buttonTypes[2];
            int n = 0;
            while (n < 3) {
                if (string3.equals(this.routeTypes[n])) {
                    this.buttonType = this.buttonTypes[n];
                    break;
                }
                ++n;
            }
            if (!iPBeans.isAddingEntry()) {
                if (this.rowSelected < 0) {
                    this.rowSelected = 0;
                }
                this.index = this.rowSelected;
                this.m_idTType = iPBeans.getTTypeList();
                this.m_idTType[this.index].setTitle(this.buttonType);
                this.m_idTType[this.index].setName("type_" + this.buttonType + "_" + this.index);
                iPBeans.setTTypeList(this.m_idTType);
                itemDescriptorArray = iPBeans.getTDestinationList();
                itemDescriptorArray[this.index].setTitle(string4);
                itemDescriptorArray[this.index].setName("dest_" + string4 + "_" + this.index);
                iPBeans.setTDestinationList(itemDescriptorArray);
                ItemDescriptor[] itemDescriptorArray2 = iPBeans.getTGatewayList();
                itemDescriptorArray2[this.index].setTitle(string5);
                itemDescriptorArray2[this.index].setName("gateway_" + string5 + "_" + this.index);
                iPBeans.setTGatewayList(itemDescriptorArray2);
                ItemDescriptor[] itemDescriptorArray3 = iPBeans.getTSubnetMaskList();
                itemDescriptorArray3[this.index].setTitle(string6);
                itemDescriptorArray3[this.index].setName("mask_" + string6 + "_" + this.index);
                iPBeans.setTSubnetMaskList(itemDescriptorArray3);
                ItemDescriptor[] itemDescriptorArray4 = iPBeans.getTDeviceList();
                itemDescriptorArray4[this.index].setTitle(string7);
                itemDescriptorArray4[this.index].setName("dev_" + string7 + "_" + this.index);
                iPBeans.setTDeviceList(itemDescriptorArray4);
            } else {
                if (string2.equals(this.before)) {
                    if (this.rowSelected < 0) {
                        this.rowSelected = 0;
                    }
                    this.index = this.rowSelected;
                } else {
                    this.index = this.rowSelected + 1;
                }
                iPBeans.addRow(this.buttonType, string4, string5, string6, string7);
            }
            itemDescriptorArray = (ItemDescriptor[])this.myPm.getAggregateManager();
            itemDescriptorArray.refreshComponent("RoutingPanel.ROUTEINFOTABLE");
            this.myPm.applyChanges();
            this.myPm.dispose();
        }
        catch (IllegalUserDataException illegalUserDataException) {
            this.myPm.handleDataException(illegalUserDataException);
        }
    }

    private void handleTypeSelection(String string) {
        this.myPm.applyChanges();
        this.db = this.myPm.getDataBeans();
        IPBeans iPBeans = (IPBeans)this.db[0];
        if (string.equals("NETBUTTON")) {
            if (iPBeans.getDestination().equals("default")) {
                iPBeans.setDestination("");
                this.myPm.setEnabled("ROUTEOK_BUTTON", false);
            }
            this.myPm.setEnabled("destinationField", true);
            this.myPm.setEnabled("subnetMaskField", true);
        } else if (string.equals("HOSTBUTTON")) {
            if (iPBeans.getDestination().equals("default")) {
                iPBeans.setDestination("");
                this.myPm.setEnabled("ROUTEOK_BUTTON", false);
            }
            iPBeans.setSubnetMask("255.255.255.255");
            this.myPm.setEnabled("destinationField", true);
            this.myPm.setEnabled("subnetMaskField", false);
        } else if (string.equals("DEFAULTBUTTON")) {
            iPBeans.setDestination("default");
            this.myPm.setEnabled("ROUTEOK_BUTTON", true);
            this.myPm.setEnabled("destinationField", false);
            this.myPm.setEnabled("subnetMaskField", true);
        }
        this.myPm.refreshComponent("destinationField");
        this.myPm.refreshComponent("subnetMaskField");
    }
}

